/*
 * Decompiled with CFR 0.152.
 */
package doggytalents.common.entity.anim;

import doggytalents.api.anim.DogAnimation;
import doggytalents.common.config.ConfigHandler;
import doggytalents.common.entity.Dog;
import doggytalents.common.entity.anim.DogAnimationState;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.Mth;

public class DogAnimationManager {
    private static final int SYNC_INTERVAL_TICK = 7;
    private static final int MIN_VAL_MAX_LATENCY = 7;
    public final DogAnimationState animationState = new DogAnimationState();
    public boolean needRefresh = false;
    private boolean started = false;
    private int animationTime;
    private final Dog dog;
    private boolean looping = false;
    private boolean holdOnLastTick = false;
    private boolean isHolding = false;
    private int tickTillSync = 0;
    private boolean isDebug = false;

    public DogAnimationManager(Dog dog) {
        this.dog = dog;
    }

    public void onAnimationChange(DogAnimation anim) {
        this.animationTime = 0;
        this.isHolding = false;
        if (anim != DogAnimation.NONE) {
            this.started = true;
            this.looping = anim.looping();
            this.holdOnLastTick = anim.holdOnLastTick();
            this.animationTime = anim.getLengthTicks();
            this.animationState.start(this.dog.f_19797_);
            this.tickTillSync = 7;
        } else {
            this.started = false;
            this.looping = false;
            this.animationState.stop();
            if (this.dog.m_9236_().f_46443_) {
                this.needRefresh = true;
            }
        }
    }

    public void tick() {
        if (this.started && !this.dog.getAnim().freeHead()) {
            this.dog.f_20883_ = this.dog.f_20885_;
            this.dog.resetBeggingRotation();
            if (!this.dog.getAnim().freeHeadXRotOnly()) {
                this.dog.m_146926_(0.0f);
                this.dog.f_19860_ = 0.0f;
            }
        }
        if (this.started && !this.dog.m_9236_().f_46443_ && !this.looping) {
            if (this.animationTime <= 0) {
                this.animationTime = 0;
                if (this.holdOnLastTick) {
                    this.isHolding = true;
                } else {
                    this.dog.setAnim(DogAnimation.NONE);
                }
            } else {
                if (--this.tickTillSync <= 0) {
                    this.tickTillSync = 7;
                    this.dog.setAnimSyncTime(this.animationTime);
                }
                --this.animationTime;
            }
        }
        if (this.started && this.dog.m_9236_().f_46443_ && !this.looping) {
            if (this.animationTime <= 0) {
                this.animationTime = 0;
                if (this.holdOnLastTick) {
                    this.isHolding = true;
                }
            } else {
                --this.animationTime;
            }
        }
        if (this.isDebug) {
            this.tickDebug();
        }
    }

    public void onSyncTimeUpdated() {
        if (this.dog.m_9236_().f_46443_) {
            this.resolveLatencyIfNeeded();
        }
    }

    private void resolveLatencyIfNeeded() {
        int currentTime;
        int correctTime;
        int latencyAbs;
        if (!this.started || this.looping) {
            return;
        }
        int configMaxLatency = (Integer)ConfigHandler.CLIENT.MAX_ANIMATION_LATENCY_ALLOWED.get();
        if (configMaxLatency < 0) {
            return;
        }
        int maxLatencyAllowed = 7;
        if (configMaxLatency > 7) {
            maxLatencyAllowed = configMaxLatency;
        }
        if ((latencyAbs = Mth.m_14040_((int)((correctTime = this.dog.getAnimSyncTime()) - (currentTime = this.animationTime)))) <= maxLatencyAllowed) {
            return;
        }
        DogAnimation anim = this.dog.getAnim();
        this.animationTime = Mth.m_14045_((int)correctTime, (int)0, (int)anim.getLengthTicks());
        int correctPassedTime = anim.getLengthTicks() - this.animationTime;
        this.animationState.resolveLatency(this.dog.f_19797_, correctPassedTime, anim.getSpeedModifier());
    }

    public boolean started() {
        return this.started;
    }

    public boolean isHolding() {
        return this.isHolding;
    }

    public void save(CompoundTag tag) {
        DogAnimDebugState debug_state = this.dog.getDogAnimDebugState();
        if (debug_state.isNone()) {
            return;
        }
        CompoundTag debug_tag = new CompoundTag();
        debug_tag.m_128405_("anim_id", debug_state.anim().getId());
        debug_tag.m_128405_("timestamp", debug_state.timestamp());
        debug_tag.m_128350_("yrot", debug_state.yRot());
        tag.m_128365_("dtnDogAnimDebug", (Tag)debug_tag);
    }

    public void load(CompoundTag tag) {
        if (!tag.m_128425_("dtnDogAnimDebug", 10)) {
            return;
        }
        CompoundTag debug_tag = tag.m_128469_("dtnDogAnimDebug");
        int anim_id = debug_tag.m_128451_("anim_id");
        int timestamp = debug_tag.m_128451_("timestamp");
        float yrot = debug_tag.m_128457_("yrot");
        DogAnimDebugState debug_state = DogAnimDebugState.of(anim_id, timestamp, yrot);
        this.setDogAnimDebugState(debug_state);
    }

    private void tickDebug() {
        this.dog.f_20885_ = this.dog.f_20883_ = this.dog.getDogAnimDebugState().yRot();
        this.dog.m_146922_(this.dog.f_20883_);
        this.dog.f_20884_ = this.dog.f_20883_;
        this.dog.f_20886_ = this.dog.f_20885_;
        this.dog.f_19859_ = this.dog.m_146908_();
    }

    public void onDebugUpdate(DogAnimDebugState state) {
        this.isDebug = !state.isNone();
    }

    public void setDogAnimDebugState(DogAnimDebugState state) {
        DogAnimDebugState old_state = this.dog.getDogAnimDebugState();
        this.dog.setDogAnimDebugState(state);
        if (state.isNone() && !old_state.isNone()) {
            this.dog.setAnim(DogAnimation.NONE);
        }
    }

    public void setDebugFreezeYRot(float yrot) {
        DogAnimDebugState current_state = this.dog.getDogAnimDebugState();
        this.setDogAnimDebugState(DogAnimDebugState.of(current_state.anim(), current_state.timestamp(), yrot));
    }

    public DogAnimDebugState getFreezeDebugState(DogAnimation anim) {
        int timestamp = anim.getLengthTicks() - this.animationTime;
        timestamp = Mth.m_14045_((int)timestamp, (int)0, (int)anim.getLengthTicks());
        DogAnimDebugState current_state = this.dog.getDogAnimDebugState();
        return DogAnimDebugState.of(anim, timestamp, current_state.yRot());
    }

    public static class DogAnimDebugState {
        public static final DogAnimDebugState NONE = new DogAnimDebugState();
        private DogAnimation anim = DogAnimation.NONE;
        private int timestamp = 0;
        private float yrot = 0.0f;

        private DogAnimDebugState() {
            this.anim = DogAnimation.NONE;
            this.timestamp = 0;
            this.yrot = 0.0f;
        }

        private DogAnimDebugState(DogAnimation anim, int timestamp, float yrot) {
            this.anim = anim;
            this.timestamp = timestamp;
            this.yrot = yrot;
        }

        public static DogAnimDebugState of(int animId, int timestamp, float yrot) {
            DogAnimation anim = DogAnimation.byId(animId);
            return DogAnimDebugState.of(anim, timestamp, yrot);
        }

        public static DogAnimDebugState of(DogAnimation anim, int timestamp, float yrot) {
            if (anim == null || anim.isNone()) {
                return NONE;
            }
            DogAnimDebugState ret = new DogAnimDebugState(anim, timestamp, yrot);
            if (ret.isNone()) {
                return NONE;
            }
            return ret;
        }

        public boolean isNone() {
            if (this == NONE) {
                return true;
            }
            return this.anim.isNone();
        }

        public DogAnimation anim() {
            return this.anim;
        }

        public int timestamp() {
            return this.timestamp;
        }

        public float yRot() {
            return this.yrot;
        }

        public boolean equals(Object obj) {
            if (this.isNone() && obj == NONE) {
                return true;
            }
            if (!(obj instanceof DogAnimDebugState)) {
                return false;
            }
            DogAnimDebugState other = (DogAnimDebugState)obj;
            if (this.isNone() && other.isNone()) {
                return true;
            }
            return this.anim == other.anim && this.timestamp == other.timestamp && this.yrot == other.yrot;
        }

        public int hashCode() {
            return Objects.hash(this.anim.getId(), this.timestamp, Float.valueOf(this.yrot));
        }
    }
}

